Attribute VB_Name = "mdCreateProjection"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function CreateProjection(inputSketch As aSketch, faces As ObjectSet, direction As Long, extent As Long, profileSide As Long, taperAngle As Double, materialStatus As Long, projectionName As String, thin As Boolean)

'Convenience Function to Project a Profile of a specified sketch onto the part

'Get the ProDESKTOP Application Object
GetApplicationObject

'Get the Active Part Document
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Continue only if Part is available
If Part Is Nothing Then
   Set CreateProjection = Nothing
   Exit Function
End If

'Get the parent workplane of the  sketch.
Dim wp As aWorkplane
Set wp = inputSketch.GetParent("Workplane")

'Set the Value of reversed
Dim plane As zPlane
Set plane = wp.GetGeometry

Dim localX As zDirection
Dim localY As zDirection
Dim planeNormal As zDirection

Set localX = wp.GetLocalX
Set localY = wp.GetLocalY
Set planeNormal = plane.GetNormal

Dim temp As zVector
Set temp = localX.Cross(localY)

Dim result As Double
result = temp.Dot(planeNormal)

Dim reversed As Boolean
If result < 0 Then
    reversed = True
Else
    reversed = False
End If

    
'Set the Value of above
Dim above As Long

If (direction = 0) Then
    If (reversed = True) Then
        above = 1
    Else
        above = direction
    End If
End If

If (direction = 1) Then
    If (reversed = True) Then
        above = 0
    Else
        above = direction
    End If
End If

If (direction = 2) Then
    above = direction
End If

Dim projection As aProjection
'perform operation to create projection
Set projection = app.GetClass("Projection").CreateProjection(Part.GetDesign, inputSketch, faces, above, extent, profileSide, taperAngle, materialStatus, thin)
projection.SetName "Projection1"
Part.UpdateDesign

Set CreateProjection = projection

End Function


